PSCAD 4.2.0

Settings
 {
 Id = "917134384.1144363111"
 Author = "reform.jayas"
 Desc = "Phasor Plotting From Matlab"
 Arch = "windows"
 Options = 8
 Build = 20
 Warn = 1
 Check = 7
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 2
  Step = 5e-005
  Plot = 0.001
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "Untitled.out"
  SFile = "tets1.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  freq = 60.0 [Hz]
  }

 }

Definitions
 {
 Component("Matlab_phasor")
  {
  Desc = ""
  FileDate = 0
  Parameters = 
   {
   Category("Configuration")
    {
    Text("Name",6,2,242,12,2)
     {
     Desc = "Matlab Module Name"
     Def = "phasor"
     Len = 30
     }
    Text("Path",6,16,242,12,2)
     {
     Desc = "Relative path of .m Files"
     Def = "mfiles"
     Len = 30
     }
    Input("Enabl",6,30,242,12,6)
     {
     Desc = "Enable=1 , Disable=0"
     Def = "1"
     Data = Real
     Len = 15
     Min = 0
     Max = 1
     }
    Input("PNUM",6,44,242,12,2)
     {
     Desc = "Plot Number"
     Def = "1"
     Data = Integer
     Len = 5
     Min = 1
     Max = 10
     }
    Input("SCALE",6,58,242,12,6)
     {
     Desc = "Scale for Vertical Axis"
     Def = "100.0"
     Data = Real
     Len = 15
     Min = 0
     }
    Input("PT",6,72,242,12,2)
     {
     Desc = "Harmonic Number for Title"
     Def = "1"
     Data = Real
     Len = 5
     Min = 1
     Max = 99
     }
    }
   }

  Nodes = 
   {
   Input("INPUT",-72,0)
    {
    Type = Real
    Dim  = [6]
    }
   Output("OUTPUT",72,0)
    {
    Type = Real
    }
   }

  Graphics = 
   {
   Rectangle(-45,-15,45,15)
   Line(-72,0,-45,0)
   Line(72,0,45,0)
   Line(-55,-3,-61,3)
   Text(-58,-1,"6")
   Text(0,6,"%PTITLE")
   Text(-1,31,"New Matlab Interface")
   Line(61,0,54,4)
   Line(54,-4,61,0)
   Line(-45,0,-52,4)
   Line(-52,-4,-45,0)
   }

  Section(EMTDC)
   {
   Dsdyn = "\
#STORAGE REAL:9 INTEGER:1
! --------------------------------------------------
! --------------------------------------------------
! PSCAD/EMTDC - MATLAB INTERFACE
! Module: $Name
#LOCAL INTEGER I_CNT
      IF($Enabl.GT.0.9) THEN
! --------------------------------------------------
! Transfer EMTDC Input Variables to Matlab Interface
! --------------------------------------------------
!
! First Input Array (REAL(6))
       I_CNT = 1
       DO WHILE ( I_CNT .LE. 6 )
          STORF(NSTORF+I_CNT-1) = $INPUT(I_CNT)
          I_CNT = I_CNT + 1
       END DO
! Second Input Variable (INTEGER)
       STORI(NSTORI)= $PNUM   
! Third Input Variable (REAL)
       STORF(NSTORF+6) = $PT
! Fourth Input Variable (REAL)
       STORF(NSTORF+7) = $SCALE
!
! --------------------------------------------------
! Call PSCAD/EMTDC Matlab Interface:
! CALL MLAB_INT(\"MFILEPATH\",\"MFILENAME\",\"Input Format\",\"Output Format\")
! --------------------------------------------------
       CALL MLAB_INT(\"%:Dir\\$Path\", \"$Name\", \"R(6) I R R\" , \"R\" )
!
! --------------------------------------------------
! Transfer Matlab Output Variables from Matlab Interface
! --------------------------------------------------
!
! First Output Array (REAL(1))
       $OUTPUT = STORF(NSTORF+8)
      ENDIF
! Update STORx Pointers
      NSTORF = NSTORF + 9
      NSTORI = NSTORI + 1
! --------------------------------------------------
! --------------------------------------------------"
   Help = "..\\pscad\\matlab\\index.htm"
   }
  }
 Module("Main")
  {
  Desc = " "
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(A/A4,Portrait,48,[597,467],100)
   {
   0.source3([648,198],3,0,50)
    {
    Name = "Source"
    Type = "1"
    Ctrl = "0"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(freq)"
    Tc = "0.05 [s]"
    ZSeq = "0"
    Imp = "0"
    Exph = "0"
    View = "1"
    Term = "0"
    R1s = "1.0 [ohm]"
    R1p = "1.0 [ohm]"
    L1p = "0.1 [H]"
    Z1 = "1.0 [ohm]"
    Phi1 = "80.0 [deg]"
    RN = "2.0"
    R0p = "1.0 [ohm]"
    L0p = "0.1 [H]"
    Z0 = "1.0 [ohm]"
    Phi0 = "80.0 [deg]"
    Es = "230.0 [kV]"
    F0 = "$(freq)"
    Ph = "91 [deg]"
    Pinit = "0.0 [pu]"
    Qinit = "0.0 [pu]"
    VCtrl = "0"
    Vdes = "1.0 [pu]"
    Vbase = "230.0 [kV]"
    Tvm = "0.02 [s]"
    Tvc = "0.05 [s]"
    PCtrl = "0"
    Pdes = "1.0 [pu]"
    Tpm = "0.02 [s]"
    Tpc = "0.05 [s]"
    P = ""
    Q = ""
    V = ""
    Theta = ""
    Ia = "IA"
    Ib = "IB"
    Ic = "IC"
    }
   0.ground([648,234],1,0,-1)
    {
    }
   -Wire-([648,162],0,0,-1)
    {
    Vertex="0,0;0,-54;54,-54"
    }
   0.pgb([1098,720],0,44836728,660)
    {
    Name = "OUT"
    Group = "Plot Scale"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   0.impulse([108,1188],0,0,260)
    {
    F = "20 [Hz]"
    Start = "0 [s]"
    Mag = "1"
    Cnfg = "0"
    INTR = "0"
    }
   -Wire-([144,1188],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([864,594],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,612],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,648],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,684],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([900,720],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1080,720],6,0,-1)
    {
    Name = "OUT"
    }
   -Wire-([1044,720],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([288,1188],2,0,-1)
    {
    Name = "CK"
    }
   0.var_switch([144,1224],0,23925128,310)
    {
    Name = "Enab/Disab"
    Group = "Matlab Control"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "Enab"
    Toff = "Disab"
    }
   0.logic([252,1188],0,0,510)
    {
    Type = "1"
    Inv = "0"
    }
   0.pgb([1098,936],0,22788568,650)
    {
    Name = "OUT2"
    Group = "Plot Scale"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([900,936],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1080,936],6,0,-1)
    {
    Name = "OUT2"
    }
   -Wire-([1062,936],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,126],2,0,-1)
    {
    Name = "IA"
    }
   -Wire-([1062,126],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,162],2,0,-1)
    {
    Name = "IB"
    }
   -Wire-([1062,162],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1062,198],2,0,-1)
    {
    Name = "IC"
    }
   -Wire-([1062,198],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1098,126],0,23923856,690)
    {
    Name = "Ia"
    Group = "Source Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.pgb([1098,162],0,23940616,70)
    {
    Name = "Ib"
    Group = "Source Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.pgb([1098,198],0,46112280,80)
    {
    Name = "Ic"
    Group = "Source Current"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.5"
    Max = "1.5"
    }
   0.var([936,684],0,23050000,170)
    {
    Name = "SCALE1"
    Group = "Plot Scale Control"
    Display = "0"
    Max = "10"
    Min = "0"
    Value = "3.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1008,684],6,0,-1)
    {
    Name = "SCALE1"
    }
   -Wire-([972,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([936,900],0,44649072,200)
    {
    Name = "SCALE2"
    Group = "Plot Scale Control"
    Display = "0"
    Max = "10"
    Min = "0"
    Value = "10.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1008,900],6,0,-1)
    {
    Name = "SCALE2"
    }
   -Wire-([972,900],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.xfmr-3p2w([756,108],0,0,20)
    {
    Name = "Trans"
    Tmva = "100.0 [MVA]"
    f = "$(freq)"
    YD1 = "0"
    YD2 = "0"
    Lead = "1"
    Xl = "0.1 [pu]"
    Ideal = "0"
    NLL = "0.0 [pu]"
    CuL = "0.0 [pu]"
    Tap = "0"
    View = "1"
    Dtls = "0"
    V1 = "230.0 [kV]"
    V2 = "230.0 [kV]"
    Enab = "1"
    Sat = "1"
    Xair = "0.2 [pu]"
    Tdc = "1.0 [s]"
    Xknee = "1.25 [pu]"
    Txk = "0 [s]"
    Im1 = "1.0 [%]"
    ILA1 = ""
    ILB1 = ""
    ILC1 = ""
    IAB1 = ""
    IBC1 = ""
    ICA1 = ""
    ILA2 = ""
    ILB2 = ""
    ILC2 = ""
    IAB2 = ""
    IBC2 = ""
    ICA2 = ""
    IMA = "IMA"
    IMB = "IMB"
    IMC = "IMC"
    FLXA = ""
    FLXB = ""
    FLXC = ""
    IMAB = ""
    IMBC = ""
    IMCA = ""
    FLXAB = ""
    FLXBC = ""
    FLXCA = ""
    }
   0.nodelabel([810,108],0,0,30)
    {
    Name = "NL"
    MeasV = "1"
    PU = "1"
    VName = "VL"
    VBase = "187.79 [kV]"
    }
   0.nodelabel([684,108],0,0,10)
    {
    Name = "NS"
    MeasV = "1"
    PU = "1"
    VName = "VS"
    VBase = "187.79 [kV]"
    }
   0.pgb([1098,1170],0,24111296,640)
    {
    Name = "OUT3"
    Group = "Plot Scale"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([900,1170],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1080,1170],6,0,-1)
    {
    Name = "OUT3"
    }
   -Wire-([1062,1170],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([936,1134],0,22287280,300)
    {
    Name = "SCALE3"
    Group = "Plot Scale Control"
    Display = "0"
    Max = "10"
    Min = "0"
    Value = "10.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1008,1134],6,0,-1)
    {
    Name = "SCALE3"
    }
   -Wire-([972,1134],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1098,1386],0,44583296,630)
    {
    Name = "OUT4"
    Group = "Plot Scale"
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -Wire-([900,1386],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1080,1386],6,0,-1)
    {
    Name = "OUT4"
    }
   -Wire-([1062,1386],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.var([936,1350],0,24210456,350)
    {
    Name = "SCALE4"
    Group = "Plot Scale Control"
    Display = "0"
    Max = "10"
    Min = "0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.datalabel([1008,1350],6,0,-1)
    {
    Name = "SCALE4"
    }
   -Wire-([972,1350],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([162,918],3,0,-1)
    {
    Name = "BM"
    }
   -Wire-([162,954],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([198,918],3,0,-1)
    {
    Name = "CM"
    }
   -Wire-([198,954],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([270,990],0,0,-1)
    {
    Name = "AP"
    }
   -Wire-([234,990],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,1026],0,0,-1)
    {
    Name = "BP"
    }
   -Wire-([234,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,1062],0,0,-1)
    {
    Name = "CP"
    }
   -Wire-([234,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([126,918],3,0,-1)
    {
    Name = "AM"
    }
   -Wire-([126,954],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.fft([162,1026],0,0,210)
    {
    Type = "3"
    Size = "0"
    F = "$(freq)"
    AMod = "1"
    PMod = "1"
    PModCS = "0"
    Filt = "0"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datalabel([72,990],2,0,-1)
    {
    Name = "IA"
    }
   -Wire-([72,990],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([72,1026],2,0,-1)
    {
    Name = "IB"
    }
   -Wire-([72,1026],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([72,1062],2,0,-1)
    {
    Name = "IC"
    }
   -Wire-([72,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([414,612],3,0,-1)
    {
    Name = "BMV"
    }
   -Wire-([414,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([450,612],3,0,-1)
    {
    Name = "CMV"
    }
   -Wire-([450,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([522,684],0,0,-1)
    {
    Name = "APV"
    }
   -Wire-([486,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([522,720],0,0,-1)
    {
    Name = "BPV"
    }
   -Wire-([486,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([522,756],0,0,-1)
    {
    Name = "CPV"
    }
   -Wire-([486,756],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([378,612],3,0,-1)
    {
    Name = "AMV"
    }
   -Wire-([378,648],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.fft([414,720],0,0,420)
    {
    Type = "3"
    Size = "0"
    F = "$(freq)"
    AMod = "1"
    PMod = "1"
    PModCS = "0"
    Filt = "0"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.ground([738,144],1,0,-1)
    {
    }
   0.resistor([756,180],3,0,-1)
    {
    R = "1E6 [ohm]"
    }
   0.ground([756,180],1,0,-1)
    {
    }
   0.resistor([1008,234],3,0,-1)
    {
    R = "100 [ohm]"
    }
   0.ground([1008,234],1,0,-1)
    {
    }
   0.resistor([954,234],3,0,-1)
    {
    R = "100 [ohm]"
    }
   0.ground([954,234],1,0,-1)
    {
    }
   0.breaker3([954,162],5,0,680)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0 [kA]"
    View = "1"
    ViewB = "0"
    DisPQ = "0"
    NAME = "Brk"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0E6 [ohm]"
    RON = "0.01 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005 [s]"
    IBRA = "IbrkA"
    IBRB = ""
    IBRC = ""
    IBR0 = ""
    SBRA = ""
    SBRB = ""
    SBRC = ""
    BP = ""
    BQ = ""
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0 [MW]"
    Q = "0 [MVAR]"
    }
   -Wire-([954,108],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.tpflt([918,180],4,0,670)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0 [kA]"
    RON = "0.01 [ohm]"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "1"
    }
   0.var_switch([810,234],0,24759744,90)
    {
    Name = "Fault"
    Group = "Fault Control"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.var_pot([810,180],0,21849368,40)
    {
    Name = "Fault Type"
    Group = "Fault Control"
    Display = "0"
    NDP = "10"
    Value = "1"
    F1 = "1"
    F2 = "2"
    F3 = "3"
    F4 = "4"
    F5 = "5"
    F6 = "6"
    F7 = "7"
    F8 = "8"
    F9 = "9"
    F10 = "10"
    }
   0.var_switch([1116,342],4,23048952,120)
    {
    Name = "Brk"
    Group = "Breaker Control"
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([1044,342],4,0,-1)
    {
    Name = "Brk"
    }
   -Wire-([1080,342],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.inductor([1008,180],3,0,-1)
    {
    L = "0.2 [H]"
    }
   -Wire-([1008,180],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([162,630],3,0,-1)
    {
    Name = "VBMS"
    }
   -Wire-([162,666],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([198,630],3,0,-1)
    {
    Name = "VCMS"
    }
   -Wire-([198,666],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.datalabel([270,702],0,0,-1)
    {
    Name = "VAPS"
    }
   -Wire-([234,702],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,738],0,0,-1)
    {
    Name = "VBPS"
    }
   -Wire-([234,738],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([270,774],0,0,-1)
    {
    Name = "VCPS"
    }
   -Wire-([234,774],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([126,630],3,0,-1)
    {
    Name = "VAMS"
    }
   -Wire-([126,666],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.fft([162,738],0,0,410)
    {
    Type = "3"
    Size = "0"
    F = "$(freq)"
    AMod = "1"
    PMod = "1"
    PModCS = "0"
    Filt = "0"
    Track = "0"
    Enab = "1"
    Fout = ""
    }
   0.datalabel([810,576],2,0,-1)
    {
    Name = "AM"
    }
   0.datatap([864,594],0,0,360)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,594],2,0,-1)
    {
    Name = "BM"
    }
   0.datatap([864,684],0,0,430)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,612],2,0,-1)
    {
    Name = "CM"
    }
   0.datatap([864,666],0,0,400)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,630],2,0,-1)
    {
    Name = "AP"
    }
   0.datatap([864,648],0,0,390)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,648],2,0,-1)
    {
    Name = "BP"
    }
   0.datatap([864,630],0,0,380)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,666],2,0,-1)
    {
    Name = "CP"
    }
   0.datatap([864,612],0,0,370)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Sticky-([72,90],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,90,522,252
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
A simple case which uses MATLAB for ploting phasor quantities. Apply the fault during simulation run and observe phasor quantities (you can change type of fault)

WARNING
* This case only works if you use the Digital/Compaq/Intel F90 Fortran Compiler.
"
    }
   -Sticky-([162,324],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 162,324,306,378
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
This is a MATLAB m-file.
Double click to see it.
"
    }
   0.datamerge([900,666],4,0,570)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([810,576],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,612],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,648],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,666],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,630],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,594],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,810],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,828],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,864],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,900],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([810,792],2,0,-1)
    {
    Name = "AM"
    }
   0.datatap([864,810],0,0,440)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,810],2,0,-1)
    {
    Name = "BM"
    }
   0.datatap([864,900],0,0,490)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,828],2,0,-1)
    {
    Name = "CM"
    }
   0.datatap([864,882],0,0,480)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,846],2,0,-1)
    {
    Name = "AP"
    }
   0.datatap([864,864],0,0,470)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,864],2,0,-1)
    {
    Name = "BP"
    }
   0.datatap([864,846],0,0,460)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,882],2,0,-1)
    {
    Name = "CP"
    }
   0.datatap([864,828],0,0,450)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datamerge([900,882],4,0,580)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([810,792],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,828],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,864],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,882],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,846],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,810],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1062],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1098],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1134],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([810,1026],2,0,-1)
    {
    Name = "AM"
    }
   0.datatap([864,1044],0,0,220)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1044],2,0,-1)
    {
    Name = "BM"
    }
   0.datatap([864,1134],0,0,290)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,1062],2,0,-1)
    {
    Name = "CM"
    }
   0.datatap([864,1116],0,0,270)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1080],2,0,-1)
    {
    Name = "AP"
    }
   0.datatap([864,1098],0,0,250)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,1098],2,0,-1)
    {
    Name = "BP"
    }
   0.datatap([864,1080],0,0,240)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1116],2,0,-1)
    {
    Name = "CP"
    }
   0.datatap([864,1062],0,0,230)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datamerge([900,1116],4,0,500)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([810,1026],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,1062],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,1098],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,1116],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,1080],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,1044],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1278],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1296],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1314],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([864,1350],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([810,1242],2,0,-1)
    {
    Name = "AM"
    }
   0.datatap([864,1260],0,0,330)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1260],2,0,-1)
    {
    Name = "VAMS"
    }
   0.datatap([864,1350],0,0,560)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,1278],2,0,-1)
    {
    Name = "AMV"
    }
   0.datatap([864,1332],0,0,550)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1296],2,0,-1)
    {
    Name = "AP"
    }
   0.datatap([864,1314],0,0,340)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([810,1314],2,0,-1)
    {
    Name = "VAPS"
    }
   0.datatap([864,1296],0,0,540)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([828,1332],2,0,-1)
    {
    Name = "APV"
    }
   0.datatap([864,1278],0,0,530)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datamerge([900,1332],4,0,590)
    {
    N = "6"
    Type = "2"
    Disp = "1"
    }
   -Wire-([810,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([810,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([828,1332],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,1296],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([828,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([882,180],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -ControlPanel-([1062,558],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1062,558
    Extents = 0,0,72,126
    Slider(23050000)
    }
   -ControlPanel-([1062,774],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1062,774
    Extents = 0,0,72,126
    Slider(44649072)
    }
   -ControlPanel-([1062,1008],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1062,1008
    Extents = 0,0,72,126
    Slider(22287280)
    }
   -ControlPanel-([1062,1224],0)
    {
    Name = ""
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 1062,1224
    Extents = 0,0,72,126
    Slider(24210456)
    }
   0.datalabel([1062,234],2,0,-1)
    {
    Name = "VL"
    }
   -Wire-([1062,234],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1098,234],0,23409080,110)
    {
    Name = "VL"
    Group = "Load Voltage"
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.8"
    Max = "0.8"
    }
   -Sticky-([180,1260],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 180,1260,306,1422
    Alignment = 0
    Style = 1
    Arrow = 80
    Color = 0,15792890
    Text = "\
Control of MATLAB
 - 0 - disable
 - 1 - enable (a 
        MATLAB 
        function is 
        called at the
        time of
        impulse)"
    }
   -Sticky-([54,1242],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 54,1242,144,1368
    Alignment = 1
    Style = 1
    Arrow = 1
    Color = 0,15792890
    Text = "Impulse generator. Its frequency controls how often a MATLAB function is called."
    }
   -Sticky-([72,576],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,576,288,594
    Alignment = 1
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Voltage at the Source side."
    }
   -Sticky-([72,882],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 72,882,270,900
    Alignment = 1
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Current at the Source"
    }
   -Sticky-([918,576],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 918,576,1026,612
    Alignment = 1
    Style = 1
    Arrow = 10
    Color = 0,15792890
    Text = "On-line Control of a plot scale"
    }
   -Sticky-([702,324],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 702,324,900,504
    Alignment = 0
    Style = 1
    Arrow = 4
    Color = 0,15792890
    Text = "\
Fault Type control:
  1 - phase A to Ground
  2 - phase B to Ground
  3 - phase C to Ground
  4 - phases A, B to Ground
  5 - phases B, C to Ground
  6 - phases C, A to Ground
  7 - phases A, B, C to Ground
  8 - phase A to phase B
  9 - phase B to phase C
 10 - phase C to phase A"
    }
   .Matlab_phasor([990,720],0,0,620)
    {
    Name = "phasor"
    Path = "mfiles"
    Enabl = "CK"
    PNUM = "1"
    SCALE = "SCALE1"
    PT = "1"
    }
   .Matlab_phasor([990,936],0,0,610)
    {
    Name = "phasor"
    Path = "mfiles"
    Enabl = "CK"
    PNUM = "2"
    SCALE = "SCALE2"
    PT = "2"
    }
   .Matlab_phasor([990,1170],0,0,520)
    {
    Name = "phasor"
    Path = "mfiles"
    Enabl = "CK"
    PNUM = "3"
    SCALE = "SCALE3"
    PT = "3"
    }
   .Matlab_phasor([990,1386],0,0,600)
    {
    Name = "phasor"
    Path = "mfiles"
    Enabl = "CK"
    PNUM = "4"
    SCALE = "SCALE4"
    PT = "1"
    }
   -SrcFile-([72,324],0)
    {
   Name = "mfiles\\phasor.m"
    }
   -Sticky-([342,846],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 342,846,630,1512
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
A PHASOR component. 

It provides the interface to a MATLAB function 'phasor'. This user-defined  function is defined in the m-file 'phasor.m'. It uses three other functions 'seqs', 'mygraph' and 'compasx', which are defined in the files 'seqs.m', 'mygraph.m' and 'compasx.m' respectively. This component plots 3 vectors in the Re-Im plane.

Input: magnitudes and phases of three vectors:
 input(1), input(2), input(3) - magnitudes  of   vectors
 input(3), input(4), input(6) - phases of vectors
       
Output: a dummy output of value zero

Parameters of  PHASOR component. 

 - Matlab Module Name
[ name of the .m file ]
 - Path of .m files   
[ it defines the path to a directory, which contains m-file used by the component ]
 - Enable=1, Disable=0
[ it controls if, and how often, a MATLAB function is called:
    0 - function is not called in present time step
    1 - function is called in present time step ]
 - Plot Number           
 [ it defines the number of a plot ]
 - Scale for Vertical Axis
 [it sets the range for Y axis]
 - Harmonic Number  for Title     
 [ it defines the number of harmonic shown as a title of plot ]

"
    }
   -Sticky-([630,576],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 630,576,756,612
    Alignment = 1
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Fundamental component of current."
    }
   -Sticky-([648,792],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 648,792,756,828
    Alignment = 1
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Second harmonic of current."
    }
   -Sticky-([648,1026],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 648,1026,756,1062
    Alignment = 1
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "Third harmonic of current."
    }
   -Wire-([900,108],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   -Sticky-([648,1206],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 648,1206,756,1314
    Alignment = 0
    Style = 1
    Arrow = 8
    Color = 0,15792890
    Text = "\
Fundamental components of:
 - current,
 - source voltage,
 - load voltage."
    }
   -Wire-([882,216],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([792,108],0,0,-1)
    {
    Vertex="0,0;162,0"
    }
   -Wire-([954,108],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -ControlPanel-([486,324],0)
    {
    Name = "Fault Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 486,324
    Extents = 0,0,108,126
    Switch(24759744)
    Dial(21849368)
    }
   -Wire-([1008,108],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   -Wire-([72,828],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datatap([90,702],3,0,130)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([90,738],3,0,150)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([90,774],3,0,180)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([72,828],3,0,-1)
    {
    Name = "VS"
    }
   -Wire-([324,810],0,0,-1)
    {
    Vertex="0,0;0,-108"
    }
   0.datatap([342,684],3,0,140)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([342,720],3,0,160)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([342,756],3,0,190)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([324,810],3,0,-1)
    {
    Name = "VL"
    }
   -Sticky-([54,18],0)
    {
    Name = ""
    Font = 2
    Bounds = 54,18,1170,54
    Alignment = 1
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "PLOTTING PHASOR QUANTITIES USING MATLAB"
    }
   -ControlPanel-([936,324],0)
    {
    Name = "Brealer Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 936,324
    Extents = 0,0,72,126
    Switch(23048952)
    }
   -Sticky-([324,576],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 324,576,540,594
    Alignment = 1
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Voltage at the Load side."
    }
   -ControlPanel-([72,1386],0)
    {
    Name = "Matlab Cntrl"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = 72,1386
    Extents = 0,0,72,126
    Switch(23925128)
    }
   0.arrow_c([576,846],4,0,-1)
    {
    }
   0.arrow_s([630,936],3,0,-1)
    {
    }
   0.arrow_s([630,1152],3,0,-1)
    {
    }
   0.arrow_s([630,1386],3,0,-1)
    {
    }
   -Sticky-([1062,414],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1062,414,1134,450
    Alignment = 1
    Style = 1
    Arrow = 5
    Color = 0,15792890
    Text = "Breaker control"
    }
   -Plot-([72,450],0)
    {
    Title = "Currents and Voltages"
    Draw = 0
    Area = [0,0,828,684]
    Posn = [306,90]
    Icon = [72,450]
    Extents = 0,0,288,18
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,288,90],"kA")
     {
     Options = 0
     Units = ""
     Curve(23923856,"Ia",0,,,)
     Curve(23940616,"Ib",1,,,)
     Curve(46112280,"Ic",2,,,)
     }
    Graph([0,90],[0,0,288,90],"kV")
     {
     Options = 0
     Units = ""
     Curve(23409080,"VL",1,,,)
     }
    }
   0.unity([216,1188],0,0,280)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([216,1224],0,0,320)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([882,180],0,0,60)
    {
    IType = "2"
    OType = "1"
    }
   0.unity([882,234],0,0,100)
    {
    IType = "2"
    OType = "1"
    }
   }
  }
 }

